#ifndef CLOCK_H_
#define CLOCK_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_rtc.h"
#include "Display.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
    CLOCK_Calibrating,
    CLOCK_Setting,
    CLOCK_Running,
    CLOCK_Alarm
}
clock_State;

/* Exported function prototypes ----------------------------------------------*/

// Clock_StartRTC()
// ----------------
// Start the real time clock.
extern void Clock_StartRTC();

// Clock_Init()
// ------------
// Initialize the clock module.
extern void Clock_Init();

// Clock_BeginCalibration()
// ------------------------
// Start the continuous reading of the ADC values from the servo calibration trimpots.
extern void Clock_BeginCalibration();

// Clock_UpdateCalibration()
// -------------------------
// Sets all servos to a known angle so that the servo calibration parameters can
// be correctly adjusted.
extern void Clock_UpdateCalibration();

// Clock_EndCalibration()
// ----------------------
// Stop the ADC conversions and leave the servo calibration parameters in a fixed state.
extern void Clock_EndCalibration();

// Clock_SetNextState()
// --------------------
// Set the next state of the clock.
extern void Clock_SetNextState();

// Clock_GetState()
// ----------------
// Get the current clock state.
extern clock_State Clock_GetState();

// Clock_ShowTime()
// ----------------
// Show a specified time on the clock display.
#define Clock_ShowTime(time) (Display_SetTime(time))

// Clock_SetTime()
// ---------------
// Set the time.
extern void Clock_SetTime(uint32_t time);

// Clock_GetTime()
// ----------------
// Get the current time.
#define Clock_GetTime() (RTC_GetCounter())

// Clock_SetAlarm()
// ----------------
// Set the alarm time.
extern void Clock_SetAlarm(uint32_t time);

// Clock_GetAlarm()
// ----------------
// Get the current alarm time.
extern uint32_t Clock_GetAlarm();

// Clock_ToggleAlarm()
// -------------------
// Enable/disable the alarm.
extern void Clock_ToggleAlarm();

// Clock_Refresh()
// ---------------
// Update the display and robot position.
extern void Clock_Refresh();

#endif /* CLOCK_H_ */
